/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NonEMFResourceProxyNode.java,v 1.5 2009/12/11 09:16:54 bjerome Exp $
 * 
 *******************************************************************************/
/*
 * Created on Mar 21, 2005
 *
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.ui.navigator.FileProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeMover;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeRenamer2;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.ActionRefactoringFactory;
import org.eclipse.ltk.core.refactoring.Change;
/**
 * @author maish02@ca.com
 * @author Jerome Bozier
 * @version December 10, 2009
 */
public  class NonEMFResourceProxyNode extends FileProxyNode implements IProxyNodeRenamer2, IProxyNodeMover {
	private List children;
	private String name;
	
	/**
	 * @param file
	 * 
	 */
	public NonEMFResourceProxyNode(IFile file) {
		super(file);
		name = file.getName();
		name = name.substring(0, name.length()-(file.getFileExtension().length()+1));
		children = new LinkedList();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.IProxyNode#getChildren()
	 */
	public IProxyNode[] getChildren() {
		return (IProxyNode[]) children.toArray(new IProxyNode[children.size()]);
	}	

	public String getText() {
		return name;
	}

	public Object getAdapter(Class adapter) {
		return super.getAdapter(adapter);
	}
	
	/**
	 * return change to rename an element based on a file and that is not an EMF element
	 */
	public Change createRenameChange(IRefactoringContext context, String newName) {
		String changedName = newName;
		IFile file = getFile();
		String extension = file.getFileExtension();
		// if newname does not already contains an extension, add it to the filename before moving
		if ((extension != null) && (extension.length() != 0)) {
			if (!changedName.endsWith(extension)) {
				changedName = changedName+"."+extension;  //$NON-NLS-1$
			}
		}
		return ActionRefactoringFactory.getInstance().createRenameFileChange(getFile(), changedName);
	}
	
	/**
	 * return change to move an element based on a file and that is not an EMF element
	 */
	public Change createMoveChange(IRefactoringContext context,IPath destinationPath) {
		// calcultate container to be able to use the change factory
		IContainer base = null;
		IPath basePath = destinationPath.removeLastSegments(1);
		if (basePath.segmentCount() == 1) {
			base = ResourcesPlugin.getWorkspace().getRoot().getProject(basePath.toString());
		}
		if ((base == null) || (!base.exists())) {
			base = ResourcesPlugin.getWorkspace().getRoot().getFolder(basePath);
		}
		if ((!base.exists())) { // should not occur : container is selected inside UI, so it should exists
			try {
				((IFolder)base).create(true, true, null); // only for safety
			} catch (CoreException e) {
				return null;
			}
		}
		return ActionRefactoringFactory.getInstance().createMoveFileChange((IFile)getAdapter(IFile.class), base);
	}
}
