/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: Proxy.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

/**
 * @author jgout
 * @version February 26, 2008
 */
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.navigator.AbstractProxy;
import org.eclipse.hyades.test.ui.navigator.IProxy;

public class Proxy extends AbstractProxy implements IProxy {
	private IResource res;
	private String id;
	
	public Proxy(IResource res, String id) {
		this.res = res;
		this.id = id;
	}

	/**
	 * Creates a proxy
	 * @param resName the workspace relative path of the underlying resource of the proxy
	 * @param id identifier of the proxy
	 */
	public Proxy(String resName, String id) {
		this.res = ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(resName));
		this.id = id;
	}

	public String getIdentifier() {
		return id;
	}

	public IResource getUnderlyingResource() {
		return res;
	}

}
