/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RTFFileProxyNode.java,v 1.1 2010/05/07 13:03:06 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.swt.graphics.Image;

/**
 * <p>RTFFileProxyNode.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version May 7, 2010
 * @since   May 7, 2010
 */
public class RTFFileProxyNode extends NonEMFResourceProxyNode {

	private Object parent = null;
		
	public RTFFileProxyNode(IFile file, Object parent) {
		
		super(file);
		
		this.parent = parent;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.FileProxyNode#getImage()
	 */
	public Image getImage() {
		return (TestUIImages.INSTANCE.getImage(TestUIImages.IMG_RTF));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.FileProxyNode#getParent()
	 */
	public Object getParent() {
		return parent;
	}	
}
