/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestAssetGroupProxyNode.java,v 1.12 2010/02/18 14:49:14 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.LogicalTestNavigatorContentProvider;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestFolderContentValidator;
import org.eclipse.hyades.test.ui.navigator.TestFolderProxyNode;
import org.eclipse.swt.graphics.Image;

/** 
 * <p>Generic test asset group proxy node.</p>
 * 
 * 
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @author  Jerome Bozier
 * @version February 4, 2010
 * @since   March 18, 2005
 */
 public class TestAssetGroupProxyNode extends TestFolderProxyNode implements ITestAssetGroupProxyNode {
	
	private String extension;
    private String name;
    private String imageKey;

	static class TestAssetGroupValidator implements ITestFolderContentValidator {
		private String extension;
		private boolean caseSensitive;
		
		public TestAssetGroupValidator(String extension,boolean caseSensitive) {
			this.extension = extension;
			this.caseSensitive = caseSensitive;
		}
		
		public boolean isFileOk(IFile file) {
			String ext = file.getFileExtension();
            if((file != null) && (ext != null)) {
            	if (caseSensitive) {
            		return ext.equals(extension);
            	} else {
            		return ext.toLowerCase().equals(extension);
            	}
            } else {
                return false;
            }
		}

		public boolean isProxyOk(IProxyNode node) {
			return true;
		}
	}
	
	public TestAssetGroupProxyNode(IProject project, String extension, String name, String imageKey, boolean flat, Object parent,boolean caseSensitive) {
		super(project, new TestAssetGroupValidator(extension,caseSensitive), LogicalTestNavigatorContentProvider.getSharedFileProxyManager(), flat, parent);
		this.extension = extension;
        this.name = name;
        this.imageKey = imageKey;
	}
	
	public boolean isApplicableFor() {
		//- A test asset group proxy node can not be renamed
		return false;
	}

	public Image getImage() {
		if(imageKey != null && imageKey.length() > 0) {
            return UiPlugin.getInstance().getImage(imageKey);
        } else {
			//- this should never appear
			return super.getImage();
		}
	}

	public String getText() {
		if(name != null && name.length() > 0) {
            return name;
		} else {
			//- this should never appear
			return ""; //$NON-NLS-1$
		}
	}

    /**
     * @return
     */
    public String getExtension() {
        return extension;
    }
}
