/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestComponentFileProxyNode.java,v 1.5 2008/03/20 19:49:54 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @version February 26, 2008
 * @since 3.2
 */
public class TestComponentFileProxyNode extends EMFResourceProxyNode {
		
	public TestComponentFileProxyNode(IFile file, Resource resource) {
		super(file, resource);
	}
	
	public TestComponentFileProxyNode(IFile file, IMemento memento) {
		super(file, memento);
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TEST_COMPONENT);
	}
	
	public String getFactoryID() {
		return EMFResourceProxyFactory.ID;
	}
	
	public boolean saveState(IMemento memento) {
		//- data to retrieve the correct object 
		memento.putString(TestUIConstants.TAG_NODE_KIND, TestUIConstants.TESTCOMPONENT_FILE_NODE);
		//- data from EMFResourceProxyNode
		memento.putString(TestUIConstants.TAG_NAME, getText());
		IProxyNode [] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			if(!saveChildState(memento, children[i]))
				return false;
		}
		return true;
	}
	
	protected String getNodeKind() {
    	return TestUIConstants.TESTCOMPONENT_FILE_NODE;
    }
	
}
