/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestOnlyFilter.java,v 1.3 2006/10/27 18:59:09 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;

/**
 * A filter display only the tests without test cases.
 * 
 * @author pnedelec
 * @since 4.0.0
 */
public class TestOnlyFilter implements IFilter {

	public boolean satisfies(String type) {
		// JC: temporary hack until we fix persistence of volatile JUnit models
		if ("org.eclipse.hyades.test.other.junit.testSuite".equals(type)) return false; //$NON-NLS-1$
		return true;
	}

	public boolean satisfies(IProxyNode node) {
        if (node instanceof IExecutionResultProxyNode
        	|| node instanceof ArtifactProxyNode
        	|| node instanceof DatapoolProxyNode
        	|| node instanceof DeploymentProxyNode
        	|| node instanceof LocationProxyNode
        	|| node instanceof ITestCaseProxyNode) return false;
    	return true;
	}

	public boolean satisfiesChildren(IProxyNode node) {
		return !(node instanceof ITestSuiteProxyNode);
	}
}
