/********************************************************************** 
 * Copyright (c) 2007, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: TestlogFileProxyNode.java,v 1.2 2008/05/09 17:52:09 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.swt.graphics.Image;

/**
 * TestlogFileProxyNode.java
 * <p/>
 * 
 * 
 * @author  Joseph P. Toomey
 * @author  Paul E. Slauenwhite
 * @version May 9, 2008
 * @since   August 16, 2007
 */
public class TestlogFileProxyNode extends NonEMFResourceProxyNode implements IProxyNode {

	private Object parent = null;
		
	public TestlogFileProxyNode(IFile file, Object parent) {
		
		super(file);
		
		this.parent = parent;
	}
	
	
	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_TESTLOG);
	}

	/**
	 * @return Returns the parent.
	 */
	public Object getParent() {
		return parent;
	}
}
