/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeProviderFactoryManager.java,v 1.3 2006/05/19 17:16:11 mddunn Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.HashMap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.ITypeProvider;

/** 
 * This class manage the extensions of org.eclipse.hyades.test.ui.testNavigatorTypeProviderProxyFactory
 * @author jgout
 * @since 4.0
 * @deprecated this class is no longer used, since the extension it manages was removed.
 */
public class TypeProviderFactoryManager {
	
	private HashMap factories;
	private HashMap types;
	
	public TypeProviderFactoryManager() {
		factories = new HashMap();
		types = new HashMap();
		IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(UiPlugin.getID() + ".testNavigatorTypeProviderProxyFactory"); //$NON-NLS-1$
		if (extPoint != null) {
			IConfigurationElement[] members = extPoint.getConfigurationElements();
			for (int i = 0; i < members.length; i++) {
				IConfigurationElement element = members[i];
				if ("factory".equals(element.getName())) { //$NON-NLS-1$
					String id = element.getAttribute("id"); //$NON-NLS-1$
					addFactory(id, element);
				} else if("elementType".equals(element.getName())) { //$NON-NLS-1$
					//- get information from the elementType attribute
					String type = element.getAttribute("type"); //$NON-NLS-1$
					String factoryID = element.getAttribute("factoryID"); //$NON-NLS-1$
					if(type != null && type.length() != 0) {
						addType(type, factoryID);
					}
				}
			}
		}
	}
	
	private void addFactory(String id, IConfigurationElement element) {
		if(!factories.containsKey(id)) {
			//- if the given type is not yet in the internal map, add it
			factories.put(id, element);
		} else {
			UiPlugin.logInfo("ID: "+id+" already used in a previously registered factory"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}
	
	private void addType(String type, String factoryID) {
		if(!types.containsKey(type)) {
			types.put(type, factoryID);
		} else {
			UiPlugin.logInfo("type: "+type+" already registered"); //$NON-NLS-1$ //$NON-NLS-2$			
		}
	}

	public ITypeProvider getFactory(String typeName) {
		if(types.containsKey(typeName)) {
			return getFactoryFromID((String)types.get(typeName));
		} else {
			return new DefaultTypeProvider();
		}
	}
	
	/** Returns the factory associated to the given id. 
	 * The factory should have been registered using the following extension point:  <code>org.eclipse.hyades.test.ui.testNavigatorTypeProviderProxyFactory</code> 
	 * @param factoryID the id of a registered factory.
	 * @return the type provider proxy factory which has been registered with the given id.
	 */
	public ITypeProvider getFactoryFromID(String factoryID) {
		Object value = factories.get(factoryID);
		if (value instanceof IConfigurationElement) {
			//- if the factory has not yet been loaded
			IConfigurationElement element = (IConfigurationElement) value;
			try {
				ITypeProvider factory = null;
				if("factory".equals(element.getName())) { //$NON-NLS-1$
					factory = (ITypeProvider)element.createExecutableExtension("class"); //$NON-NLS-1$
				} else {
					//- old extension point
					factory = (ITypeProvider)element.createExecutableExtension("factory"); //$NON-NLS-1$
				}
				return factory;
			} catch (CoreException e) {
				UiPlugin.logError(e);
				//- problem building the instance of factory using reflection
				return new DefaultTypeProvider();
			} 
		} else {
			//- the factory has been loaded yet
			if (value instanceof ITypeProvider) {
				return (ITypeProvider) value;
			} else {
				UiPlugin.logError("internal error"); //$NON-NLS-1$
				//- problem with stored factory (this should never appear)
				return null;
			}
		}
	}
}
