/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLFileProxyNode.java,v 1.1 2008/03/14 18:03:03 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.swt.graphics.Image;

/**
 * XMLFileProxyNode.java.
 * <p/>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 13, 2008
 * @since   March 13, 2008
 */
public class XMLFileProxyNode extends NonEMFResourceProxyNode {

	private Object parent = null;
		
	public XMLFileProxyNode(IFile file, Object parent) {
		
		super(file);
		
		this.parent = parent;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.FileProxyNode#getImage()
	 */
	public Image getImage() {
		return (TestUIImages.INSTANCE.getImage(TestUIImages.IMG_XML));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.navigator.FileProxyNode#getParent()
	 */
	public Object getParent() {
		return parent;
	}	
}
