/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FileProxiesRequest.java,v 1.5 2009/01/20 09:14:48 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.Collection;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.IExtendedProxyNode;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestNavigatorResourceRefreshJob;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

/**
 * A ProxiesRequest that performs the long-running computation of proxy nodes for a
 * collection of files, using a FileProxyManager.
 * @author jcanches, jbozier
 * @since 4.3
 * @version January 7, 2009
 */
public class FileProxiesRequest extends ProxiesRequest implements ITestNavigatorResourceRefreshJob {

	private IFileProxyManager fileProxyManager;
	private IContainer parent;
	
	/**
	 * Constructs a new request.
	 * @param files The list of files for which proxy nodes must be computed.
	 * @param fileProxyManager The FileProxyManager used to compute the proxies.
	 * @param parent The common parent of all returned proxies.
	 */
	public FileProxiesRequest(Collection files, IFileProxyManager fileProxyManager, IContainer parent, TestNavigator testNavigator) {
		super(NLS.bind(TestNavigatorMessages.PM_EXPLORING_FOLDER, parent.getFullPath().toString()), files, testNavigator);
		this.fileProxyManager = fileProxyManager;
		this.parent = parent;
		//this.setRule(parent);
	}
	
	/**
	 * Returns the common parent of all computed proxies.
	 * @return the common parent of all computed proxies.
	 */
	public IContainer getParent() {
		return parent;
	}
	
	protected IProxyNode computeProxy(Object key) {
		return fileProxyManager.getProxy((IFile)key, parent);
	}
	
	protected IProxyNode getPlaceHolder(Object key) {
		return new TemporaryProxyNode((IFile)key, parent);
	}
	
	protected String getTaskName() {
		return NLS.bind(TestNavigatorMessages.PM_EXPLORING_FOLDER, parent.getFullPath().toString());
	}
	
	protected String getSubTaskName(Object key) {
		return NLS.bind(TestNavigatorMessages.PM_INDEXING_FILE, ((IFile)key).getName());
	}

	private static class TemporaryProxyNode implements IExtendedProxyNode {

		private IFile file;
		private Object parent;

		public TemporaryProxyNode(IFile file, Object parent) {
			this.file = file;
			this.parent = parent;
		}

		public IProxyNode[] getChildren() {
			return new IProxyNode[0];
		}

		public Image getImage() {
			// TODO Auto-generated method stub
			return null;
		}

		public Object getParent() {
			return parent;
		}

		public String getText() {
			return file.getName();
		}

		public Object getAdapter(Class adapter) {
			return Platform.getAdapterManager().getAdapter(this, adapter);
		}

		public String getIdentifier() {
			return "#"; //$NON-NLS-1$
		}

		public IResource getUnderlyingResource() {
			return file;
		}

		public IResource getCorrespondingResource() {
			return file;
		}
		
	}
	
}
