/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProxiesRequestListener.java,v 1.3 2007/04/26 18:50:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

/**
 * Listener of ProxiesRequest. This listener is notified of various events that occur in
 * the lifecycle of ProxiesRequest instances.
 * @author jcanches
 * @since 4.3
 */
public interface IProxiesRequestListener {

	/**
	 * Indicates that a proxy has been computed.
	 * @param request The request that was emitted and from which this event is sent.
	 * @param key The key whose proxy was computed.
	 */
	void proxyComputed(ProxiesRequest request, Object key);
	
	/**
	 * Indicates that at least one proxy has been computed since the last call to this method,
	 * or since {@link ProxiesRequest#wait(int, IProxyRequestListener, int)} has been called if
	 * this method has never been called before. This kind of notification is guaranted not to
	 * occur more often than the specified notification interval specified in the wait method,
	 * unless there are no more proxies to compute, in this case the notification occurs as soon
	 * as the last proxy is computed.
	 */
	void proxiesComputed(ProxiesRequest request);
	
	/**
	 * Indicates that the request has been completed.
	 * @param request The request that was emitted and which is now complete.
	 */
	void computationCompleted(ProxiesRequest request);
	
	/**
	 * Indicates that the request has been cancelled.
	 * @param request The request that was emitted and then cancelled.
	 */
	void computationCancelled(ProxiesRequest request);
	
}
