/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISynchronizedAccess.java,v 1.3 2007/04/26 18:50:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

/**
 * A synchronized access allows only one instance to access a given resource.
 * The typical use is:
 * <pre>
 * try {
 *   if (access.acquireLock(resource)) {
 *     // Do something with the resource
 *   }
 * } finally {
 *   access.releaseLock(resource);
 * }
 * </pre>
 * Note that releaseLock must be called EVEN IF acquireLock failed.
 * @author jcanches
 * @since 4.3
 */
public interface ISynchronizedAccess {

	boolean acquireLock(Object resource);

	void releaseLock(Object resource);

}
