/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogicalProjectProxiesRequest.java,v 1.6 2009/01/20 09:14:48 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.Collection;

import org.eclipse.core.resources.IProject;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestAssetGroupProxyManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypeProviderManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestNavigatorLogicalRefreshJob;
import org.eclipse.osgi.util.NLS;

/**
 * Request that computes the {@link org.eclipse.hyades.test.ui.navigator.ITypeProviderProxyNode}s and the {@link org.eclipse.hyades.test.ui.internal.navigator.proxy.ITestAssetGroupProxyNode}
 * of a project. A request is a job that can be run as a background job, and that provides
 * additional events to the requester.
 * @author jcanches, jbozier
 * @since 4.3
 * @version January 7, 2009
 */
public class LogicalProjectProxiesRequest extends ProxiesRequest implements ITestNavigatorLogicalRefreshJob {

	public static final String TYPE_PROVIDER_PREFIX = "#"; //$NON-NLS-1$
	public static final String TEST_ASSET_EXTENSION_PREFIX = "~"; //$NON-NLS-1$
	
	private IProject project;
	private TypeProviderManager typeProviderManager;
	private TestAssetGroupProxyManager testAssetGroupProxyManager;
	
	public LogicalProjectProxiesRequest(Collection requests, TypeProviderManager typeProviderManager, TestAssetGroupProxyManager testAssetGroupProxyManager, IProject project, TestNavigator testNavigator) {
		super(NLS.bind(TestNavigatorMessages.PM_EXPLORING_PROJECT, project.getName()), requests, testNavigator);
		this.project = project;
		this.typeProviderManager = typeProviderManager;
		this.testAssetGroupProxyManager = testAssetGroupProxyManager;
		//this.setRule(project);
	}
	
	public IProject getProject() {
		return project;
	}
	
	protected IProxyNode computeProxy(Object key) {
		String req = (String)key;
		if (req.startsWith(TYPE_PROVIDER_PREFIX)) {
			return typeProviderManager.getTypeProviderProxyNode(project, req.substring(1));
		} else if (req.startsWith(TEST_ASSET_EXTENSION_PREFIX)) {
			return testAssetGroupProxyManager.getTestAssetGroup(project, req.substring(1));
		}
		return null;
	}

	protected IProxyNode getPlaceHolder(Object key) {
		return null;
	}

	protected String getTaskName() {
		return NLS.bind(TestNavigatorMessages.PM_EXPLORING_PROJECT, project.getName());
	}
	
	protected String getSubTaskName(Object key) {
		String req = (String)key;
		if (req.startsWith(TYPE_PROVIDER_PREFIX)) {
			return NLS.bind(TestNavigatorMessages.PM_INDEXING_TYPE, req.substring(1));
		} else if (req.startsWith(TEST_ASSET_EXTENSION_PREFIX)) {
			return NLS.bind(TestNavigatorMessages.PM_INDEXING_ASSET_GROUP, req.substring(1));
		}
		return ""; //$NON-NLS-1$
	}

}
