/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SynchronizedAccess.java,v 1.6 2009/06/30 17:11:50 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>A general purpose synchronizer that allows only one instance to access a given resource.</p>
 * 
 * <p>This synchronizer is mainly useful in multi-threaded contexts where one thread needs
 * exclusive access to a resource.</p>
 * 
 * <p><b>NOTE:</b> This synchronizer is susceptible to deadlock and should NOT be used.  
 * Instead, use {@ILock}.</p> 
 * 
 * 
 * @author     Julien Canches
 * @author     Jerome Bozier
 * @author     Paul Slauenwhite
 * @version    June 30, 2009
 * @since      February 28, 2007
 * @deprecated As of TPTP 4.5.2, use {@ILock}.
 */
public class SynchronizedAccess implements ISynchronizedAccess {

	public class MapItems {
		private int nbRef = 0;
		private Thread thread = null;
		
		public MapItems(Thread thread) {
			this.nbRef = 1;
			this.thread = thread;
		}
		
		public int getNbRef() {
			return nbRef;
		}
		
		public Thread getThread() {
			return thread;
		}
		
		public void release() {
			nbRef --;
		}
		
		public void addref() {
			nbRef ++;
		}
	}
	
	private Map maps = Collections.synchronizedMap(new HashMap());
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ISynchronizedAccess#acquireLock(java.lang.Object)
	 */
	public boolean acquireLock(Object resource) {
		synchronized(maps) {
			MapItems item = (MapItems)maps.get(resource);
			if (item != null) { // lock already exists
				if (item.getThread() == Thread.currentThread()) {
					item.addref();
				} else {
					// wait no more ref to add one
					while (true) {
						try {
							maps.wait();
							item = (MapItems)maps.get(resource);
							if (item == null) { // no more lock => add a new one
								item = new MapItems(Thread.currentThread());
								maps.put(resource,item);
								return true;
							} else {
								if (item.getThread() == Thread.currentThread()) {
									item.addref();
									return true;
								}
							}
						} catch (InterruptedException e) {
							return false;
						}
					}
				}
			} else { // no lock => create one
				item = new MapItems(Thread.currentThread());
				maps.put(resource,item);
			}
    		return true;
    	}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.async.ISynchronizedAccess#releaseLock(java.lang.Object)
	 */
	public void releaseLock(Object resource) {
		synchronized(maps) {
			MapItems item = (MapItems)maps.get(resource);
			if (item == null) {
				return;
			}
			if (item.getThread() != Thread.currentThread()) {
				return;
			}
			item.release();
			if (item.nbRef <= 0) { // all lock released => remove general lock
				maps.remove(resource);
			}
			maps.notify();
    	}
	}

}
