/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestNavigatorJob.java,v 1.3 2007/04/26 18:50:09 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.async;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;

/**
 * Abstract job that belongs to a {@link TestNavigator} instance family. When disposed,
 * a test navigator cancels all jobs that belongs to its family.
 * @author jcanches
 * @since 4.3
 */
public abstract class TestNavigatorJob extends Job {

	private TestNavigator testNavigator;
	
	/**
	 * Constructs a job that belongs to the specified testNavigator.
	 * @param name Name of the job.
	 * @param testNavigator Instance of the test navigator that this job is a member of.
	 */
	protected TestNavigatorJob(String name, TestNavigator testNavigator) {
		super(name);
		this.testNavigator = testNavigator;
	}
	
	public boolean belongsTo(Object family) {
		if (testNavigator.equals(family)) return true;
		return super.belongsTo(family);
	}

}
