/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: CompositeReferencerProxyNode.java,v 1.2 2008/11/19 18:12:02 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.internal.execution.local.control.NotImplementedException;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.swt.graphics.Image;

/**
 * Wrapper class around a (referencer or not) proxy node.
 * The proxy node part is same as the wrapped one.
 * The references of this proxy node is built by grouping all references found of the whole proxy node hierarchy.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.3
 */
public class CompositeReferencerProxyNode implements IReferencerProxyNode {
	private IProxyNode proxy;
	//- map that associate a type name to the collection of referenced elements for this type of reference
	//- (typeName, Set(Referenced))
	private Map types;
	
	public CompositeReferencerProxyNode(IProxyNode proxy) {
		super();
		this.proxy = proxy;
		types = new HashMap();
		getDeepReferences(proxy);
	}

	public Set getReferenceTypes() {
		return types.keySet();
	}

	public Collection getReferences(String refType) {
		return (Collection) types.get(refType);
	}

	private void getDeepReferences(IProxyNode p) {
		if (p instanceof IReferencerProxyNode) {
			//- first, add all its references
			IReferencerProxyNode referencer = (IReferencerProxyNode) p;
			Set allTypes = referencer.getReferenceTypes();
			if (allTypes != null) {
				for (Iterator it = allTypes.iterator(); it.hasNext();) {
					String type = (String) it.next();
					types.put(type, referencer.getReferences(type));
				}
			}
		}
		//- next, add those contained by its children
		IProxyNode[] children = p.getChildren();
		for (int i = 0; i < children.length; i++) {
			getDeepReferences(children[i]);
		}
	}

	/**
	 * This method is not intended to be called in this extender.
	 * Throws a NotImplementedException.
	 */
	public void removeReference(IProxyNode reference) {
		throw new NotImplementedException();
	}
	
	public String getIdentifier() {
		return proxy.getIdentifier();
	}

	public IResource getUnderlyingResource() {
		return proxy.getUnderlyingResource();
	}

	public IProxyNode[] getChildren() {
		return proxy.getChildren();
	}

	public Image getImage() {
		return proxy.getImage();
	}

	public Object getParent() {
		return proxy.getParent();
	}

	public String getText() {
		return proxy.getText();
	}

	public Object getAdapter(Class adapter) {
		if(adapter == IProxyNode.class) {
			return proxy;
		}
		return proxy.getAdapter(adapter);
	}

	public boolean equals(Object obj) {
		if (obj instanceof CompositeReferencerProxyNode) {
			CompositeReferencerProxyNode c = (CompositeReferencerProxyNode) obj;
			return proxy.equals(c.proxy);
		}
		return false;
	}

	public int hashCode() {
		return proxy.hashCode();
	}

	public IProxyNode getProxy() {
		return proxy;
	}
}
