/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IReferenceRegistrySavedState.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import org.eclipse.core.runtime.IPath;

/**
 * Generic interface that provides the common feature of Eclipse ISavedState
 * and ISaveContext methods. It provides a lookup feature for retrieving the
 * real file associated to a symbolic file in a given save state.
 * @author jcanches
 * @version February 26, 2008
 * @see org.eclipse.core.resources.ISavedState
 * @see org.eclipse.core.resources.ISaveContext
 * @since 4.3
 */
public interface IReferenceRegistrySavedState {


	/**
	 * @see org.eclipse.core.resources.ISavedState#lookup(org.eclipse.core.runtime.IPath)
	 * @see org.eclipse.core.resources.ISaveContext#lookup(org.eclipse.core.runtime.IPath)
	 */
	public IPath lookup(IPath path);
		

}
