/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: Reference.java,v 1.1 2008/03/20 19:49:53 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy.reference;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNodeCache;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.Proxy;
import org.eclipse.hyades.test.ui.navigator.IProxy;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

/**
 * @author jgout
 * @version February 26, 2008
 */
public class Reference {
	private String type;
	private String proxyId;
	private IFile proxyFile;
	
	public Reference(String type, String proxyId, IFile proxyFile) {
		if(type == null || proxyId == null || proxyFile == null) {
			throw new IllegalArgumentException("Can not create reference with null value"); //$NON-NLS-1$
		}
		this.type = type;
		this.proxyId = proxyId;
		this.proxyFile = proxyFile;
	}
	
	public Reference(String type, IProxy proxy) {
		IResource ulr = proxy.getUnderlyingResource();
		if (ulr instanceof IFile) {
			this.proxyFile = (IFile) ulr;
		}
		this.type = type;
		this.proxyId = proxy.getIdentifier();
	}

	/**
	 * Returns the referenced proxy node.
	 * @return the referenced proxy node or <code>null</code> 
	 * if the file that was containing it no longer exists. 
	 */
	public IProxyNode getReferencedProxy() {
		return FileProxyNodeCache.getInstance().getCorrespondingProxy(new Proxy(proxyFile, proxyId));
	}

	public String getType() {
		return type;
	}
	
	public IFile getProxyFile() {
		return proxyFile;
	}
	
	public String getProxyId() {
		return proxyId;
	}

	public boolean equals(Object arg0) {
		if(arg0 == this) return true;
		if (arg0 instanceof Reference) {
			Reference ref = (Reference) arg0;
			if (ref != null) {
				return ref.type.equals(type) && ref.proxyId.equals(proxyId) && ref.proxyFile.equals(proxyFile);
			}
		}
		return false;
	}

	public int hashCode() {
		return proxyFile.hashCode();
	}
}
