/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: CompositeChangeWithRoot.java,v 1.1 2008/03/20 19:49:52 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

/**
 * @author jgout
 * @version February 26, 2008
 */
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CompositeChangeWithRoot extends CompositeChange {
	private Change root;
	private String name;

	public CompositeChangeWithRoot(Change root) {
		super(""); //$NON-NLS-1$
		Assert.isNotNull(root);
		this.root = root;
	}
	
	public CompositeChangeWithRoot(Change root, String name) {
		super(name);
		//- in this constructor, root can be null 
		this.root = root;
		if(root == null) {
			Assert.isLegal(name != null && name.length() > 0, "Empty name with null root"); //$NON-NLS-1$
			this.name = name;
		}
	}

	public String getName() {
		return root != null ? root.getName() : name;
	}

	public Change freeze() {
		if(getChildren().length == 0) {
			return root;
		}
		if (root instanceof CompositeChange) {
			merge((CompositeChange)root);
		} else {
			add(root);
		}
		
		return this;
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
		pm.beginTask("", getChildren().length+1); //$NON-NLS-1$
		try {
			RefactoringStatus status = super.isValid(new SubProgressMonitor(pm, getChildren().length));
			if (root != null) {
				status.merge(root.isValid(new SubProgressMonitor(pm, 1)));
			}
			return status;
		} finally {
			pm.done();
		}
	}

}
