/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.test.ui.navigator.refactoring.RefactoringEvent;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/**
 * this change surround a set of changes to trigger listeners attached to refactoring action 
 * it does not show on refactoring view
 * @author jbozier
 * @since 4.5.2
 * @version February 6, 2009
 *
 */
public class CompositeListenerChange extends CompositeChange {
	private RefactoringEvent event;
	
	public CompositeListenerChange(RefactoringEvent event) {
		super(""); //$NON-NLS-1$
		this.event = event;
		super.markAsSynthetic();
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		TestNavigatorRefactoringListenerManager.triggerStart(event);
		Change undo = super.perform(pm);
		TestNavigatorRefactoringListenerManager.triggerEnd(event);
		return undo;
	}	
	
	public boolean isEnabled() {
		boolean needToPerform = true;
		Change[] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			needToPerform &= ((Change)children[i]).isEnabled();
		}
		return needToPerform;
	}
}
