/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: CustomRefactoringManager.java,v 1.1 2009/11/27 14:44:22 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/**
 * this manager is provided mainly for internal tests
 * it allow user to add its own start and end change in the refactoring wizard for all the actions
 * @author Jerome Bozier
 * @version November 25, 2009
 * @provisional As of TPTP 4.6.2, this is stable provisional API.
 */
public class CustomRefactoringManager {
	private static List allCustomRefactoring = null;
	
	/**
	 * register a custom refactoring : 
	 * at start of action, the Change coming from ICustomRefactoring.getStartChange() will be added if not null
	 * at end of action, the Change coming from ICustomRefactoring.getEndChange() will be added if not null
	 * on a same action, if several custom refactoring are registered, they will all be added in the registering order
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */

	public static void RegisterCustomRefactoring(ICustomRefactoring refactoring) {
		if (refactoring == null) {
			return;
		}
		if (allCustomRefactoring == null) {
			allCustomRefactoring = new ArrayList();
		}
		allCustomRefactoring.add(refactoring);
	}

	/**
	 * unregister a previously registered custom refactoring
	 * if same custom refactoring have been registered several time, the first one will be unregistered
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */

	public static void UnRegisterCustomRefactoring(ICustomRefactoring refactoring) {
		if ((refactoring == null) || (allCustomRefactoring == null)) {
			return;
		}
		allCustomRefactoring.remove(refactoring);
	}

	/**
	 * add all starting change of the matching kind to the parent change 
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */
	public static void addAllStartingChange(CompositeChange parent,int kind) {
		if (parent == null) {
			return;
		}
		List allEndChange = getAllStartingChange(kind);
		for (Iterator it = allEndChange.iterator(); it.hasNext();) {
			Change start = (Change)it.next();
			parent.add(start);
		}
	}
	
	/**
	 * return all starting changes of the matching kind
	 */
	private static List getAllStartingChange(int kind) {
		List ret = new ArrayList();
		if ((allCustomRefactoring != null) && (!allCustomRefactoring.isEmpty())) {
			for (Iterator it = allCustomRefactoring.iterator(); it.hasNext(); ) {
				ICustomRefactoring ref = (ICustomRefactoring)it.next();
				if (ref.getKind() == kind) {
					Change start = ref.getStartChange();
					if (start != null) {
						ret.add(start);
					}
				}
			}
		}
		return ret;
	}
	
	/**
	 * add all ending change of the matching kind to the parent change 
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */
	public static void addAllEndingChange(CompositeChange parent,int kind) {
		if (parent == null) {
			return;
		}
		List allEndChange = getAllEndingChange(kind);
		for (Iterator it = allEndChange.iterator(); it.hasNext();) {
			Change start = (Change)it.next();
			parent.add(start);
		}
	}
	
	/**
	 * return all ending changes of the matching kind
	 */
	private static List getAllEndingChange(int kind) {
		List ret = new ArrayList();
		if ((allCustomRefactoring != null) && (!allCustomRefactoring.isEmpty())) {
			for (Iterator it = allCustomRefactoring.iterator(); it.hasNext(); ) {
				ICustomRefactoring ref = (ICustomRefactoring)it.next();
				if (ref.getKind() == kind) {
					Change start = ref.getEndChange();
					if (start != null) {
						ret.add(start);
					}
				}
			}
		}
		return ret;
	}
}
