/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DefaultProxyNodeDeleter.java,v 1.3 2008/12/23 13:56:12 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IProxyNodeDeleter;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;

/**
 * This class stands as the default deleter for proxy node.
 * This class should only be used on proxy nodes that are adaptable in IFile.
 * This class is not intented to be used/subclassed by clients.
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version December 23, 2008
 * @since   March 20, 2008
 */
public class DefaultProxyNodeDeleter implements IProxyNodeDeleter,IProxyNode {
	private IFile proxyFile;
	private IProxyNode proxy;
	
	public DefaultProxyNodeDeleter(IProxyNode proxy) {
		this.proxyFile = (IFile) proxy.getAdapter(IFile.class);
		this.proxy = proxy;
		Assert.isNotNull(proxyFile);
	}

	public Change createDeleteChange(IRefactoringContext context) {
		return new DeleteFileChange(proxyFile);
	}

	public IProxyNode[] getChildren() {		
		return proxy.getChildren();
	}

	public Image getImage() {
		return proxy.getImage();
	}

	public Object getParent() {
		return proxy.getParent();
	}

	public String getText() {
		return proxy.getText();
	}

	public Object getAdapter(Class adapter) {
		return proxy.getAdapter(adapter);
	}

	public String getIdentifier() {
		return proxy.getIdentifier();
	}

	public IResource getUnderlyingResource() {
		return proxy.getUnderlyingResource();
	}
}
