/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteContainerChange.java,v 1.7 2009/11/27 14:44:22 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

/**
 * <p>DeleteContainerChange.java</p>
 *
 *
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;

public class DeleteContainerChange extends ReorgContainerChange {
	private boolean physicalDelete = false;
	private boolean isProject = false;
	private List associationList;
	
	public DeleteContainerChange(IContainer cont,boolean physicalDelete,List associationList) {
		super(cont);
		this.isProject = (cont instanceof IProject);
		this.physicalDelete = physicalDelete;
		if (!isProject) {
			this.setEnabled(physicalDelete);
		}
		this.associationList = associationList;
		updateAssociationMapping(cont);
	}

	public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
		Change undo = null;
		try {
			if (container instanceof IProject) {
				TrashBox.instance().trashProject((IProject)container, physicalDelete);
			} else {
				TrashBox.instance().trashResource(container);
			}
			undo = TrashBox.instance().createUntrashChange(container);
		} catch (Exception e) {
			UiPlugin.logError("error while putting container into trashbox : "+container.getName());
			UiPlugin.logError(e);
		}
		if (associationList != null) {
			for (Iterator it = associationList.iterator(); it.hasNext(); ) {
				Change proxChange = (Change)it.next();
				if (!proxChange.isEnabled()) {
					return undo;
				}
			}
		}
		try {			
			if (container instanceof IProject) {
				((IProject)container).delete(physicalDelete, true, monitor);
			} else {
				container.delete(true, monitor);
			}
		} catch (CoreException e) {
			UiPlugin.logError(e);
		}
		return undo;
	}

	public String getName() {
		if (isProject) {
			return NLS.bind(RefactoringMessages.DELETE_PROJECT, getPath().toString());
		} else {
			return NLS.bind(RefactoringMessages.DELETE_FOLDER, getPath().toString());
		}
	}

}
