/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteContainerCompositeChange.java,v 1.7 2009/11/27 14:44:22 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

/**
 * DeleteContainerCompositeChange.java
 *
 *
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.osgi.util.NLS;

public class DeleteContainerCompositeChange extends ReorgContainerCompositeChange {
	private DeleteContainerChange delChange;
	private boolean physicalDelete = true;
	private List associationList;
	
	public DeleteContainerCompositeChange(IContainer container,boolean physicalDelete,String baseDisplayName,List associationList) {
		super(NLS.bind(baseDisplayName, container.getFullPath().toString()), container);
		delChange = new DeleteContainerChange(container,physicalDelete,associationList);
		this.associationList = associationList;
		this.physicalDelete = physicalDelete;
	}

	public Change getDeleteContainerChange() {
		return delChange;
	}

	public Change getRootChange() {
		return delChange;
	}
	
	public Change perform(IProgressMonitor pm) throws CoreException {
		//- if one of children is not enabled, we do not perform on root
		boolean needToPerform = true;
		if (associationList != null) {
			for(Iterator it = associationList.iterator(); it.hasNext();) {
				Change proxChange = (Change)it.next();
				needToPerform &= proxChange.isEnabled();
			}
		}
		Change[] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			needToPerform &= ((Change)children[i]).isEnabled();
		}
		Change undo = null;
		if(needToPerform) {
			if ((getContainer() instanceof IProject) && (physicalDelete)) {
				// in case of project with physical delete, we make the global delete only
				IWorkspace ws = ResourcesPlugin.getWorkspace();
				IWorkspaceDescription desc = ws.getDescription();
				boolean autobuilding = desc.isAutoBuilding();
				if (autobuilding) {
					desc.setAutoBuilding(false);
					ws.setDescription(desc);
				}
				undo = getRootChange().perform(pm);
				if (autobuilding) {
					desc.setAutoBuilding(true);
					ws.setDescription(desc);
				}
			} else {
				CompositeChange composite = new CompositeChange("undo");
				Change child = performChilds(pm);
				composite.add(getRootChange().perform(pm));
				composite.add(child); // when deleting a container, we have to make the undo in reverse order (re-create parent before recreate child)
				undo = composite;
			}
		} else {
			undo = performChilds(pm);
		}
		return undo; 
	}
}
