/**********************************************************************
 * Copyright (c) 2009, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeleteLogicalProjectChange.java,v 1.4 2010/08/25 07:43:27 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * 
 * @author Jerome Bozier
 * @version August 24, 2010
 */
public class DeleteLogicalProjectChange extends Change {
	private IProject project;
	
	public DeleteLogicalProjectChange(IProject project) {
		super();
		this.project = project;
	}

	public Object getModifiedElement() {		
		return project;
	}

	public String getName() {
		return NLS.bind(RefactoringMessages.REMOVE_PROJECT, project.getName());
	}

	public void initializeValidationData(IProgressMonitor pm) {
		// no operation
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		if (!project.isAccessible()) {
			if (project.exists()) { // project is closed
				status.addWarning(RefactoringMessages.NOT_OPEN_PROJECT);
			} else {
				status.addFatalError(RefactoringMessages.NOT_EXIST_PROJECT);
			}			
		} else {
			ResourceAttributes resAtt = project.getResourceAttributes();
			if (resAtt == null) {
				status.addError(RefactoringMessages.ERROR);
			} else {			
				if (resAtt.isReadOnly()) {				
					status.addWarning(RefactoringMessages.READ_ONLY_PROJECT);					
				}
			}
		}		
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		Change undo = null;
		try {		
			try {
				TrashBox.instance().trashProject(project, false);
			} catch (Exception e) {
				UiPlugin.logError("error while putting project into trashbox : "+project.getName());
				UiPlugin.logError(e);
			}
			try {
				undo = TrashBox.instance().createUntrashChange(project);
			} catch (Exception e) {
				UiPlugin.logError("error while creating undo delete for project : "+project.getName());
				UiPlugin.logError(e);
			}
			project.delete(false, true, new SubProgressMonitor(pm, 1));
		} catch (CoreException e) {
			UiPlugin.logError(e);
		}
		return undo;
	}
}
