/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteModelElementChange.java,v 1.5 2010/02/03 14:01:03 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * <p>Delete model element change.</p>
 *
 *
 * @author  Jerome Bozier
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version February 3, 2010
 * @since   March 20, 2008
 */
public class DeleteModelElementChange extends Change {
	private IProxyNode proxy;
	protected EMFRefactoringTransaction context;
	private Change fileChange;
	
	public DeleteModelElementChange(IRefactoringContext context, EObjectProxyNode node) {
		this.proxy = node;
		this.context = (EMFRefactoringTransaction)context.getRefactoringTransaction(EMFRefactoringTransaction.EMF_REFACTORING_TRANSACTION_ID);
		//- if the proxy node can be adpated in IFile we need to remove the file as well.
		Object file = node.getAdapter(IFile.class);
		if(file != null) {
			this.fileChange = new DeleteFileChange((IFile) file);
		} else {
			this.fileChange = new NullChange(NLS.bind(RefactoringMessages.UPDATE_PROXY, proxy.getUnderlyingResource().getFullPath().toPortableString()));
		}
	}

	public Object getModifiedElement() {
		return null;
	}

	public String getName() {
		return fileChange.getName();
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		return fileChange.isValid(pm);
	}

	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		fileChange.setEnabled(enabled);
	}
	
	public Change perform(IProgressMonitor pm) throws CoreException {
		URI uri = ((EObjectProxyNode)proxy).getOriginatorURI();
 		Resource res = context.getResourceSet().getResource(uri.trimFragment(), true);
 		EObject eObject = res.getEObject(uri.fragment());
		if (eObject != null) {
			EMFUtil.remove(eObject);
		}
		if (fileChange instanceof NullChange) {
			context.addSavedResource(res);
		} else {
			return fileChange.perform(pm);
		}
		return null;
	}

}
