/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteRefactoringWizard.java,v 1.7 2010/03/22 13:02:59 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/**
 * DeleteRefactoringWizard.java
 *
 *
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @author  Paul E. Slauenwhite
 * @version March 22, 2010
 * @version April 17, 2009
 */
public class DeleteRefactoringWizard extends RefactoringWizard {
	private DeleteRefactoringInputPage page;
	
	private class DeleteRefactoringInputPage extends UserInputWizardPage {
		private DeleteRefactoring refactoring;
		private Button check;
		private Button delete; 
		private Button update; 
		
		public DeleteRefactoringInputPage(Refactoring ref) {
			super(""); //$NON-NLS-1$
			this.refactoring = (DeleteRefactoring) ref;
		}

		public void createControl(Composite parent) {
			initializeDialogUnits(parent);
			Composite result= new Composite(parent, SWT.NONE);
			setControl(result);
			result.setLayout(new GridLayout());
			addLabel(result);
			if (refactoring.isProjectRemove()) {
				addProjectCheckBox(result);
			} else {
				addDeleteRemoveCheckBox(result);
			}
			Dialog.applyDialogFont(result);
		}
		

		private void addDeleteRemoveCheckBox(Composite parent) {
			refactoring.setPhysicalDelete(true);
			check = new Button(parent, SWT.CHECK);
			check.setText(RefactoringMessages.DELETE_DEEP_REMOVE);
			check.setSelection(true);
			updateRefactoring(true);
			check.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					updateRefactoring(check.getSelection());
				}
			});
			update = new Button(parent, SWT.CHECK);
			update.setText(RefactoringMessages.DeleteResourcesWizard_project_updateContents);
			update.setSelection(true);
			updateUpdateRefactoring(true);
			update.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					updateUpdateRefactoring(update.getSelection());
				}
			});
		}

		private void addProjectCheckBox(Composite parent) {
			delete = new Button(parent, SWT.CHECK);
			update = new Button(parent, SWT.CHECK);
			update.setText(RefactoringMessages.DeleteResourcesWizard_project_updateContents);
			update.setSelection(false);
			if (refactoring.isProjectClosed()) {
				update.setEnabled(false);
			}
			updateUpdateRefactoring(false);
			update.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					updateUpdateRefactoring(update.getSelection());
				}
			});
			
			check = new Button(parent, SWT.CHECK);
			if (refactoring.isProjectClosed()) {
				check.setEnabled(false);
			}
			check.setText(RefactoringMessages.DELETE_DEEP_REMOVE);
			check.setSelection(false);
			updateRefactoring(false);
			check.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					updateRefactoring(check.getSelection());
				}
			});
			
			delete.setText(RefactoringMessages.DeleteResourcesWizard_project_deleteContents);
			delete.setSelection(false);
			updateDelete(false);
			delete.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					updateDelete(delete.getSelection());
				}
			});
		}

		private void updateForcePreview() {
			DeleteRefactoringWizard.this.setForcePreviewReview(refactoring.getDeepRemove()||(refactoring.isProjectRemove() && refactoring.getPhysicalDelete())|refactoring.getUpdate());
		}
		
		protected void updateRefactoring(boolean deepRemove) {
			refactoring.setDeepRemove(deepRemove);		
			updateForcePreview();
		}		

		protected void updateUpdateRefactoring(boolean updateValue) {
			refactoring.setUpdate(updateValue);			
			updateForcePreview();
		}
		
		public boolean canFlipToNextPage() {
			return true;
		}
		
		protected void updateDelete(boolean realDelete) {
			refactoring.setPhysicalDelete(realDelete);
			updateForcePreview();
			if (realDelete) {
				if (!refactoring.isProjectClosed()) {
					check.setSelection(realDelete);
					update.setSelection(realDelete);
					check.setEnabled(false);
					update.setEnabled(false);
					page.getContainer().updateButtons();
					updateUpdateRefactoring(update.getSelection());
					updateRefactoring(check.getSelection());
				}
			} else {
				if (!refactoring.isProjectClosed()) {
					check.setEnabled(true);
					update.setEnabled(true);
					page.getContainer().updateButtons();
				}
			}
		}		
		
		private Control addLabel(Composite parent) {
			Label label= new Label(parent, SWT.NONE);
			String text;
			int containers= refactoring.getContainers().size();
			int proxies= refactoring.getProxies().size();

			if (containers == 0 && proxies == 1) {
				text= NLS.bind(RefactoringMessages.DELETE_CONFIRM_1, ((IProxyNode)refactoring.getProxies().get(0)).getText());
			} else if (containers == 1 && proxies == 0) {
				text= NLS.bind(RefactoringMessages.DELETE_CONFIRM_1, ((IResource)refactoring.getContainers().get(0)).getName());
			} else {
				text= NLS.bind(RefactoringMessages.DELETE_CONFIRM_N, String.valueOf(containers + proxies));
			}
			label.setText(text);
			label = new Label(parent, SWT.NONE); //- spacing the first label
			label.setLayoutData(new GridData(SWT.BEGINNING, GridData.FILL, false, true));
			return label;
		}		
	}
	
	public DeleteRefactoringWizard(Refactoring refactoring) {
		super(refactoring, DIALOG_BASED_USER_INTERFACE | NONE);
	}
	
	protected void addUserInputPages() {
		page = new DeleteRefactoringInputPage(getRefactoring());
		addPage(page);
	}
}
