/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: DeleteTestInvocationChange.java,v 1.3 2010/02/03 14:01:03 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.IDecision;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IReferencerProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * <p>Delete test invocation change.</p>
 *
 *
 * @author  Jerome Bozier
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version February 3, 2010
 * @since   March 20, 2008
 */
public class DeleteTestInvocationChange extends Change {
	private EMFRefactoringTransaction context;
	private IProxyNode invokee;
	private DefaultTestSuiteProxyNode test;
	
	public DeleteTestInvocationChange(IRefactoringContext context, DefaultTestSuiteProxyNode node, IReferencerProxyNode referenced) {
		this.context = (EMFRefactoringTransaction) context.getRefactoringTransaction(EMFRefactoringTransaction.EMF_REFACTORING_TRANSACTION_ID);
		Assert.isNotNull(this.context);
		this.test = node;
		this.invokee = (IProxyNode) referenced.getAdapter(IProxyNode.class);
	}

	public Object getModifiedElement() {
		return test;
	}

	public String getName() {
		return NLS.bind(RefactoringMessages.DELETE_INVOCATION, invokee.getText(), test.getText());
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		return new RefactoringStatus();
	}

	private void removeTestInvocation(IBlock block, URI invokeeURI) {
		if (block != null) {
			Collection actions = block.getActions();
			for (Iterator it = actions.iterator(); it.hasNext();) {
				Object action = it.next();
				if (action instanceof ILoop) {
					removeTestInvocation(((ILoop) action).getBlock(), invokeeURI);
				} else if (action instanceof IDecision) {
					IDecision ifAction = (IDecision) action;
					removeTestInvocation(ifAction.getFailureBlock(), invokeeURI);
					removeTestInvocation(ifAction.getSuccessBlock(), invokeeURI);
				} else if (action instanceof ITestInvocation) {
					ITestInvocation invocationAction = (ITestInvocation) action;
					TPFTest invokedTest = (TPFTest)invocationAction.getInvokedTest(); // here return the test case
					if (EcoreUtil.getURI(invokedTest).equals(invokeeURI)) { // here we check with the test suite => does not work....
						it.remove();
					} else {
						if (invokedTest instanceof ITestCase) {
							EObject parent = invokedTest.eContainer();
							if (parent instanceof TPFTest) {
								invokedTest = (TPFTest)parent;
							}
						}
						if (EcoreUtil.getURI(invokedTest).equals(invokeeURI)) { // here we check with the test suite => does not work....
							it.remove();
						}
					}
				}
			}
		}
	}
	
	public Change perform(IProgressMonitor pm) throws CoreException {
		if (invokee instanceof EObjectProxyNode) {
			URI invokeeURI = ((EObjectProxyNode)invokee).getOriginatorURI();
			//- load the test
			Resource res = context.getResourceSet().getResource(test.getOriginatorURI().trimFragment(), true);
			TPFTestSuite testObject = (TPFTestSuite) res.getEObject(test.getOriginatorURI().fragment());
			//- remove all invocations of invokee contained in test
			removeTestInvocation(testObject.getImplementor().getBlock(), invokeeURI);
			context.addSavedResource(res);
		}
		return null;
	}

}
