/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ICustomRefactoring.java,v 1.1 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.ltk.core.refactoring.Change;

/**
 * this interface is provided mainly for internal tests
 * it allow user to add its own start and end change in the refactoring wizard for all the actions
 * @author Jerome Bozier
 * @version November 25, 2009
 * @provisional As of TPTP 4.6.2, this is stable provisional API.
 */

public interface ICustomRefactoring {

	/**
	 * all the different Kind of actions on witch the custom refactoring can apply
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.	 
	 */
	public final static int MOVE 	= 1;	
	public final static int RENAME 	= 2;	
	public final static int PASTE 	= 3;	
	public final static int DELETE 	= 4;	
	/**	 
	 * @return change to be added at start of the action refactoring tree
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */
	public Change getStartChange();
	
	/**	 
	 * @return change to be added at end of the action refactoring tree
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */
	public Change getEndChange();
	
	/**
	 * return the kind of action on witch the custom refactoring apply
	 * @provisional As of TPTP 4.6.2, this is stable provisional API.
	 */
	public int getKind();
}
