/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: IResourceSetRefactoringContext.java,v 1.1 2008/03/20 19:49:52 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.Set;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * Interface used to collect and postpone change to perform on EMF models.
 * This interface is not intended to be implemented by clients.
 * 
 * @author jgout
 * @version February 26, 2008
 * @since 4.3
 */
public interface IResourceSetRefactoringContext {

	/**
	 * Adds the given resource into the set of resources that have been loaded.
	 * @param res a resource
	 */
	public void addResourceToSave(Resource res);
	
	/**
	 * Returns the set of resources that are to be saved.
	 * @return the set of resources that are to be saved.
	 */
	public Set getResourcesToSave();
	
	/**
	 * Returns the resource set in which the resource have been loaded.
	 * @return the resource set in which the resource have been loaded.
	 */
	public ResourceSet getResourceSet();
	
	/**
	 * Gathers the resource which the URI has to be changed at the end.
	 * @param res the resource which the URI should be changed
	 * @param newURI the new URI to set.
	 */
	public void addChangedURI(Resource res, URI newURI);
	
	/**
	 * Gets the new URI for the given resource
	 * @param res a resource which a new URI should be set.
	 * @return the new URI.
	 */
	public URI getNewURI(Resource res);
	
	/**
	 * Returns the set of resources that which URI should be changed.
	 * @return the set of resources that which URI should be changed.
	 */
	public Set getResourcesToMove();
}
