/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: LaunchConfigurationDeleteChange.java,v 1.1 2008/03/20 19:49:52 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * @author jgout
 * @version February 26, 2008
 */
public class LaunchConfigurationDeleteChange extends Change {

	private ILaunchConfiguration config;
	
	public LaunchConfigurationDeleteChange(ILaunchConfiguration config) {
		super();
		this.config = config;
	}

	public Object getModifiedElement() {
		return this.config;
	}

	public String getName() {
		return NLS.bind(RefactoringMessages.LaunchConfigurationDeleteChange_NAME, config.getName());
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		config.delete();
		return null;
	}

}
