/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ModelPathChange.java,v 1.6 2010/04/12 12:38:49 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * <p>Model path change.</p>
 *
 *
 * @author  Jerome Bozier
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version April 12, 2010
 * @since   March 20, 2008
 */
public class ModelPathChange extends Change {
	private EObjectProxyNode referenced;
	private EMFRefactoringTransaction context;
	private IPath newPath;

	public ModelPathChange(EObjectProxyNode node, IRefactoringContext context, IPath destinationPath) {
		this.referenced = node;
		this.context = (EMFRefactoringTransaction) context.getRefactoringTransaction(EMFRefactoringTransaction.EMF_REFACTORING_TRANSACTION_ID);
		this.newPath = destinationPath;
		Assert.isNotNull(this.context);
	}

	public Object getModifiedElement() {
		return referenced;
	}

	public String getName() {
		return NLS.bind(RefactoringMessages.UPDATE_PROXY_PATH_CHANGED, referenced.getText());
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		return new RefactoringStatus();
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		//- load the referenced
		Resource res = context.getResourceSet().getResource((referenced).getOriginatorURI().trimFragment(), true);
		context.addSavedResource(res);
		context.addChangedResourceURI(res, URI.createPlatformResourceURI(newPath.toPortableString(), false));		
		return null;
	}

}
