/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: MoveFileChange.java,v 1.3 2009/11/27 14:44:22 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * MoveFileChange.java
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
public class MoveFileChange extends Change {

	private IFile file;
	private IContainer destFolder;

	public MoveFileChange(IFile file, IContainer destination) {
		super();
		this.file = file;
		this.destFolder = destination;
	}

	public Object getModifiedElement() {
		return file;
	}

	public String getName() {
		IPath path = file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
		return NLS.bind(RefactoringMessages.MOVE_FILE, path.toString(), destFolder.getFullPath().toString());
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		IFile destFile = destFolder.getFile(new Path(file.getName()));
		if (!file.exists()) {
			status.addError(RefactoringMessages.NO_FILE);
		}
		if(destFile.exists()) {
			status.addWarning(NLS.bind(RefactoringMessages.ALREADY_EXISTS_FILE, destFile.getFullPath().toPortableString()));
		}
		if (file.isReadOnly()) {
			status.addWarning(RefactoringMessages.READ_ONLY_FILE);
		}
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		Change undo = null;
		pm.beginTask("", 1);  //$NON-NLS-1$
		try {
			IPath targetPath = destFolder.getFullPath().append(file.getName()); 
			IContainer parent = file.getParent();
			if (parent != null) {
				undo = new MoveFileChange(ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath), parent);
			}
			file.move(targetPath, false, true, pm);
			pm.worked(1);
			return undo;
		} finally {
			pm.done();
		}
	}

}
