/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: MoveFolderChange.java,v 1.4 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * MoveFolderChange.java
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
public class MoveFolderChange extends ReorgContainerChange {
	protected IPath destPath;

	public MoveFolderChange(IFolder folder, IPath destPath) {
		super(folder);
		this.destPath = destPath;
	}

	public IPath getDestinationPath() {
		return destPath;
	}
	
	public String getName() {
		IPath path = getPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
		return NLS.bind(RefactoringMessages.MOVE_FOLDER, path.toString(), destPath.toString());
	}

	public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
		Change undo = null;
		try {
			IPath targetPath = destPath.append(container.getName());
			IContainer parent = container.getParent();
			if (parent != null) {
				IContainer dest;
				IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
				if (destPath.segmentCount() == 1) { // project
					dest = root.getProject(destPath.toOSString());
				} else {
					dest = root.getFolder(destPath);
				}
				IFolder folder = dest.getFolder(new Path(container.getName()));
				undo = new MoveFolderChange(folder, parent.getFullPath());
			}
			container.move(targetPath, false, monitor);
		} catch (CoreException e) {
			UiPlugin.logError("Unable to move container", e); //$NON-NLS-1$
		}
		
		TestUIUtilities.recursiveRefreshProxy(ResourcesPlugin.getWorkspace().getRoot().getFolder(destPath.append(container.getName())));
		return undo;
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		IFolder folder = (IFolder) getModifiedElement();
		if(!folder.isAccessible()) {
			status.addFatalError(RefactoringMessages.NO_FOLDER);
		}
		return super.isValid(pm);
	}

}
