/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: MoveFolderCompositeChange.java,v 1.2 2009/11/27 14:44:22 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/**
 * @author Jerome Gout
 * @author Jerome Bozier
 * @version November 20, 2009
 */
public class MoveFolderCompositeChange extends CompositeChange {
	private IFolder folder;
	private MoveFolderChange root;

	public MoveFolderCompositeChange(IFolder folder, IPath newPath) {
		super(""); //$NON-NLS-1$
		this.folder = folder;
		this.root = new MoveFolderChange(folder, newPath);
	}

	public Object getModifiedElement() {
		return folder;
	}

	public String getName() {
		return root.getName();
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
		RefactoringStatus status = root.isValid(pm);
		if(folder.getFullPath().isPrefixOf(root.getDestinationPath())) {
			status.addFatalError(RefactoringMessages.INNER_FOLDER_MOVE_ERROR);
		}
		status.merge(super.isValid(pm));
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		CompositeChange undo = new CompositeChange("undo MoveFolderCompositeChange");  //$NON-NLS-1$ (not visible in UI)
		pm.beginTask("", getChildren().length+1);  //$NON-NLS-1$
		try {
			//- children are update changes
			undo.add(super.perform(new SubProgressMonitor(pm, getChildren().length)));
			//- move the folder and all its content
			undo.add(root.perform(new SubProgressMonitor(pm, 1)));
		} finally {
			pm.done();
		}
		return undo;
	}
	
	public void freeze() {
		if(getChildren().length == 0) {
			markAsSynthetic();
			//- add a dummy child in order to keep the composite alive
			add(new NullChange(getName()));
		}
	}

}
