/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: PasteFolderChange.java,v 1.6 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtilities;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * Change to apply to perform a folder paste.
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
public class PasteFolderChange extends ReorgContainerChange {
	private IPath destPath;
	private IPath targetPath;
	private RefactoringStatus status;
	private IFolder folder;

	public PasteFolderChange(IFolder folder, IPath destPath,IPath [] finalPath) {
		super(folder);
		this.folder = folder;
		this.destPath = destPath;
		this.status = new RefactoringStatus();
		this.targetPath = handleFolderAlreadyExists(folder,destPath);
		if ((finalPath != null) && (finalPath.length > 0)) {
			finalPath[0] = targetPath;
		}
	}

	// update target path in case of conflict
	private IPath handleFolderAlreadyExists(IFolder folder, IPath destPath) {
		IPath path = destPath.append(folder.getName());
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		if ((root.getFolder(path).exists()) || (root.getFile(path).exists())) {
			boolean done = false;		
			String folderName = path.lastSegment();
			String ret = null;
			String newName = null;
			for (int i=0; (!done); i++) {
				 if (i != 0) {
					 newName = NLS.bind(TestNavigatorMessages.FileFolderInContainerPaste_NameTwoArg,new Integer(i),folderName);
				 } else {
					 newName = NLS.bind(TestNavigatorMessages.FileFolderInContainerPaste_NameOneArg,folderName);					 
				 }
				 ret = path.removeLastSegments(1).append(newName).toPortableString();
				 IPath newpath = new Path(ret);
				 done = (!root.getFolder(newpath).exists()) && (!root.getFile(newpath).exists());
			}
			path = destPath.append(newName);
		} 
		return path;
	}
	
	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
		RefactoringStatus localStatus =  this.status;
		String targetDir = targetPath.toOSString();
		if (!TestUIUtil.isResourcePathLengthValid(targetDir)) {
			localStatus.addFatalError(RefactoringMessages.LONG_NAME);
		}
		IResource[] members = folder.members();
		for (int i=0; i<members.length; i++) {
			if (!TestUIUtil.isResourcePathLengthValid(targetPath.toOSString()+"\\"+members[i].getName())) {
				localStatus.addFatalError(RefactoringMessages.LONG_NAME);
			}
		}
		return localStatus;
	}
	
	public IPath getDestinationPath() {
		return destPath;
	}
	
	public String getName() {
		IPath path = getPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
		return NLS.bind(RefactoringMessages.PASTE_FOLDER, path.toString(), targetPath.toString());
	}

	public Change reorgFolder(IContainer container, SubProgressMonitor monitor) {
		Change undo = null;
		try {
			container.copy(targetPath, 0, monitor);
			container.refreshLocal(IResource.DEPTH_INFINITE, monitor);
		} catch (CoreException e) {
			UiPlugin.logError("Unable to copy container", e); //$NON-NLS-1$
		}
		undo = new DeleteContainerChange(ResourcesPlugin.getWorkspace().getRoot().getFolder(targetPath), true, null);
		TestUIUtilities.recursiveRefreshProxy(ResourcesPlugin.getWorkspace().getRoot().getFolder(targetPath));
		return undo;
	}

}
