/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: PasteFolderCompositeChange.java,v 1.2 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

/**
 * change to apply to perform a folder paste when it have childrens 
 * children paste don't appear in refactoring view
 * @author Jerome Bozier
 * @version November 20, 2009
 * @since 4.5
 */
public class PasteFolderCompositeChange extends CompositeChange {
	private IFolder folder;
	private PasteFolderChange root;

	public PasteFolderCompositeChange(IFolder folder, IPath newPath,IPath [] targetPath) {
		super(""); //$NON-NLS-1$
		this.folder = folder;
		this.root = new PasteFolderChange(folder, newPath,targetPath);
	}

	public Object getModifiedElement() {
		return folder;
	}

	public String getName() {
		return root.getName();
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
		RefactoringStatus status = root.isValid(pm);
		if(folder.getFullPath().isPrefixOf(root.getDestinationPath())) {
			status.addFatalError(RefactoringMessages.INNER_FOLDER_PASTE_ERROR);
		}
		status.merge(super.isValid(pm));
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		pm.beginTask("", getChildren().length+1);  //$NON-NLS-1$
		try {
			CompositeChange undo = new CompositeChange("paste undo");  //$NON-NLS-1$ (not visible in editor)
			//- paste the folder and all its content
			undo.add(root.perform(new SubProgressMonitor(pm, 1)));
			//- children are update changes
			undo.add(super.perform(new SubProgressMonitor(pm, getChildren().length)));
			return undo;
		} finally {
			pm.done();
		}
	}
	
	public void freeze() {
		if(getChildren().length == 0) {
			markAsSynthetic();
			//- add a dummy child in order to keep the composite alive
			add(new NullChange(getName()));
		}
	}
}
