/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.Change;

/**
 * Change that deletes a physical resource
 * 
 * 
 * @author  Jerome Bozier
 * @version April 29, 2009
 */

public abstract class PhysicalDeleteChange extends Change {
	private static DeleteRefactoring refactoring = null;
	private IResource resource;
	
	public void updateAssociationMapping(IResource resource) {
		if (refactoring == null) {
			return;
		}
		this.resource = resource;
		IContainer parent = resource.getParent();
		while (parent != null) {
			List linked = (List)refactoring.getAssociationMap().get(parent);
			if (linked == null) {
				linked = new ArrayList();
				refactoring.getAssociationMap().put(parent, linked);
			}
			boolean exist = false;
			for (Iterator it = linked.iterator(); (it.hasNext()) && (!exist);) {
				exist = (((PhysicalDeleteChange)it.next()).resource == resource);
			}
			if (!exist) {
				linked.add(this);
			}
			parent = parent.getParent();
		}
	}
	
	public static void setDeletetefactoring(DeleteRefactoring delrefactoring) {
		refactoring = delrefactoring;
	}
}
