/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: RefactoringTransactionRootChange.java,v 1.1 2008/03/20 19:49:52 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.hyades.test.ui.navigator.IRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/**
 * Root change of move and rename action. 
 * The performChange implementation has a transactional behavior according to the following pattern:
 *  - context.beginChanges()
 *  - Children perfomChange()
 *  - context.commitChanges()
 *  That way, it is guarantee that refactoring transactions (stored in the context) 
 *  commit their changes after children ones. 
 * @author jgout
 * @version February 26, 2008
 * @since 4.3
 */
public class RefactoringTransactionRootChange extends CompositeChange {
	private IRefactoringTransaction context;

	private final class SaveResourceSetRunnable implements IWorkspaceRunnable {
		private Change undoChange;
		
		public void run(IProgressMonitor monitor) throws CoreException {
			undoChange = RefactoringTransactionRootChange.super.perform(monitor);
		}
		
		public Change getUndoChange() {
			return undoChange;
		}
	}

	public RefactoringTransactionRootChange(IRefactoringTransaction context) {
		super(""); //$NON-NLS-1$
		this.context = context;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		pm.beginTask("", 3); //$NON-NLS-1$
		try {
			CompositeChange undo = new CompositeChange("");//$NON-NLS-1$
			context.beginChanges(new SubProgressMonitor(pm, 1));
			try {
				//- Children performChange()
				SaveResourceSetRunnable action = new SaveResourceSetRunnable();
				ResourcesPlugin.getWorkspace().run(action, new SubProgressMonitor(pm, 1));
				undo.add(action.getUndoChange());
			} catch (CoreException t) {
				context.cancelChanges(pm);
				throw t;
			}		
			undo.add(context.commitChanges(new SubProgressMonitor(pm, 1)));
			return undo;
		} finally {
			pm.done();
		}		
	}

}
