/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: RenameFileChange.java,v 1.3 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * RenameFileChange.java
 * 
 * 
 * @author  Jerome Gout
 * @author  Jerome Bozier
 * @version November 20, 2009
 * @since   March 20, 2008
 */
public class RenameFileChange extends Change {
	private IFile file;
	private String name;

	public RenameFileChange(IFile file, String name) {
		this.file = file;
		this.name = name;
	}

	public Object getModifiedElement() {
		return file;
	}

	public String getName() {
		String newPathName = file.getParent().getFullPath().append(new Path(name)).toString();
		IPath path = file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
		return NLS.bind(RefactoringMessages.RENAME_FILE,path.toString(), newPathName);
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException,	OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		IFile destFile = file.getParent().getFile(new Path(name));
		if (!file.exists()) {
			status.addError(RefactoringMessages.NO_FILE);
		}
		if (file.isReadOnly()) {
			status.addWarning(RefactoringMessages.READ_ONLY_FILE);
		}
		if(destFile.exists()) {
			status.addWarning(NLS.bind(RefactoringMessages.ALREADY_EXISTS_FILE, destFile.getFullPath().toPortableString()));
		}
		return status;
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		Change undo = null;
		try {
			pm.beginTask("", 1);  //$NON-NLS-1$
			IContainer parent = file.getParent();
			String originalName = file.getName();
			IPath newPath = parent.getFullPath().append(new Path(name));
			if (parent != null) {
				undo = new RenameFileChange(parent.getFile(new Path(name)), originalName);
			}
			file.move(newPath, false, true, pm);
			pm.worked(1);
			return undo;
		} finally {
			pm.done();
		}
	}

}
