/********************************************************************** 
 * Copyright (c) 2008, 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ReorgContainerCompositeChange.java,v 1.3 2009/11/27 14:44:21 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/**
 * Abstract class for handling move and delete of a container.
 * The resulted change has a root change (move or delete of the folder itself) and children
 * whose are move or delete of each container member.
 * 
 * @author Jerome Gout
 * @author Jerome Bozier
 * @version November 20, 2009
 * @since 4.3
 * 
 */
public abstract class ReorgContainerCompositeChange extends CompositeChange {
	private IContainer container;
	private Change rootChange;
	
	public ReorgContainerCompositeChange(String name, IContainer container) {
		super(name);
		this.container = container;
	}
	
	public Object getModifiedElement() {
		return container;
	}
	
	public abstract Change getRootChange();

	public Change perform(IProgressMonitor pm) throws CoreException {
		//- if one of children is not enabled, we do not perform on root
		boolean needToPerform = true;
		Change[] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			needToPerform &= ((Change)children[i]).isEnabled();
		}
		CompositeChange undo = new CompositeChange("undo"); //$NON-NLS-1$  (invisible change performed during undo)
		undo.add(performChilds(pm));
		if(needToPerform) {
			if (rootChange == null) {
				rootChange = getRootChange();
			}
			undo.add(rootChange.perform(pm));
		}
		return undo; 
	}

	protected Change performChilds(IProgressMonitor pm) throws CoreException {		
		 return super.perform(pm);
	}

	public String getName() {
		if(rootChange == null) {
			rootChange = getRootChange();
		}
		return rootChange.getName();
	}

	protected IContainer getContainer() {
		return container;
	}
}
