/********************************************************************** 
 * Copyright (c) 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: ResourceSetRefactoring.java,v 1.1 2008/03/20 19:49:52 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/**
 * @author jgout
 * @version February 26, 2008
 * @deprecated
 */
class ResourceSetRefactoring implements IResourceSetRefactoringContext {
	private Set resources;
	private Map newURIs;
	private ResourceSet resourceSet;
	
	public ResourceSetRefactoring() {
		this.resources = new HashSet();
		this.newURIs = new HashMap();
		this.resourceSet = new ResourceSetImpl();
	}

	public void addChangedURI(Resource res, URI newURI) {
		newURIs.put(res, newURI);
	}

	public void addResourceToSave(Resource res) {
		resources.add(res);
	}

	public URI getNewURI(Resource res) {
		return (URI)newURIs.get(res);
	}

	public ResourceSet getResourceSet() {
		return resourceSet;
	}

	public Set getResourcesToSave() {
		return resources;
	}

	public Set getResourcesToMove() {
		return newURIs.keySet();
	}
}
