/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: 
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.test.ui.navigator.refactoring.ITestNavigatorRefactoringListener;
import org.eclipse.hyades.test.ui.navigator.refactoring.RefactoringEvent;

/**
 * manager for refactoring listeners
 * @author jbozier
 * @since 4.5.2
 * @version January 12, 2009
 *
 */
public class TestNavigatorRefactoringListenerManager {
	private List[] listenerArray = null;
	private static TestNavigatorRefactoringListenerManager instance = null;

	private TestNavigatorRefactoringListenerManager() {
		listenerArray = new List[ITestNavigatorRefactoringListener.KIND_NUMBER];
		for (int i=0; i<ITestNavigatorRefactoringListener.KIND_NUMBER; i++) {
			listenerArray[i] = new ArrayList();
		}
	}
	
	public static TestNavigatorRefactoringListenerManager getInstance() {
		if (instance == null) {
			instance = new TestNavigatorRefactoringListenerManager();
		}
		return instance;
	}
	
	public void addListener(ITestNavigatorRefactoringListener listener) {
		if (listener == null) {
			return;
		}
		int kind = listener.getKind();
		if (kind < ITestNavigatorRefactoringListener.KIND_NUMBER) {
			listenerArray[kind].add(listener);
		}
	}
	
	public void removeListener(ITestNavigatorRefactoringListener listener) {
		if (listener == null) {
			return;
		}
		boolean done = false;
		for (int i=0; (i<ITestNavigatorRefactoringListener.KIND_NUMBER) && (!done); i++) {
			done = listenerArray[i].remove(listener);
		}
	}
		
	public static void triggerStart(RefactoringEvent event) {
		int kind = event.getKind();
		if (kind >= ITestNavigatorRefactoringListener.KIND_NUMBER) {
			return;
		}
		List allListener = getInstance().listenerArray[kind];
		if (allListener == null) {
			return;
		}
		for (Iterator it = allListener.iterator(); it.hasNext(); ) {
			ITestNavigatorRefactoringListener listener = (ITestNavigatorRefactoringListener)it.next();
			if (listener.startEnable()) {
				listener.start(event);
			}
		}
	}

	public static void triggerEnd(RefactoringEvent event) {
		int kind = event.getKind();
		if (kind >= ITestNavigatorRefactoringListener.KIND_NUMBER) {
			return;
		}
		List allListener = getInstance().listenerArray[kind];
		if (allListener == null) {
			return;
		}
		for (Iterator it = allListener.iterator(); it.hasNext(); ) {
			ITestNavigatorRefactoringListener listener = (ITestNavigatorRefactoringListener)it.next();
			if (listener.endEnable()) {
				listener.end(event);
			}
		}
	}
}
