/********************************************************************** 
 * Copyright (c) 2008, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: UpdateModelChange.java,v 1.4 2010/02/03 14:01:03 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.internal.navigator.refactoring.resources.RefactoringMessages;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.navigator.actions.IRefactoringContext;
import org.eclipse.hyades.test.ui.navigator.refactoring.EMFRefactoringTransaction;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

/**
 * <p>Update model change.</p>
 *
 *
 * @author  Jerome Bozier
 * @author  Jerome Gout
 * @author  Paul Slauenwhite
 * @version February 3, 2010
 * @since   March 20, 2008
 */
public class UpdateModelChange extends Change {
	private EObjectProxyNode referencer;
	private EMFRefactoringTransaction context;

	public UpdateModelChange(EObjectProxyNode node, IRefactoringContext context) {
		this.referencer = node;
		this.context = (EMFRefactoringTransaction) context.getRefactoringTransaction(EMFRefactoringTransaction.EMF_REFACTORING_TRANSACTION_ID);
		Assert.isNotNull(this.context);
	}

	public String getName() {
		return NLS.bind(RefactoringMessages.UPDATE_REFERENCES, referencer.getText());
	}

	public Change perform(IProgressMonitor pm) throws CoreException {
		//- load the referencer
		Resource res = context.getResourceSet().getResource(referencer.getOriginatorURI().trimFragment(), true);
		EcoreUtil.resolveAll(res); 
		context.addSavedResource(res);
		return new UndoUpdateModelChange();
	}

	// placeholder class, just to not have a null change as undo (else, undo are canceled)
	// does nothing because transaction mechanism already deals this part of undo
	private class UndoUpdateModelChange extends Change {

		public Object getModifiedElement() {
			return null;
		}

		public String getName() {
			return "UndoUpdateModelChange"; //$NON-NLS-1$ // only for undo, not visible inside UI
		}

		public void initializeValidationData(IProgressMonitor pm) {			
		}

		public RefactoringStatus isValid(IProgressMonitor pm)
				throws CoreException, OperationCanceledException {
			return new RefactoringStatus();
		}

		public Change perform(IProgressMonitor pm) throws CoreException {
			return null;
		}
		
	}
	
	public Object getModifiedElement() {
		return referencer;
	}

	public void initializeValidationData(IProgressMonitor pm) {
	}

	public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
		return new RefactoringStatus();
	}

}
