/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteAssociation.java,v 1.7 2008/01/21 17:19:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Preference page to customize the test suite associations.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestSuiteAssociation 
extends AssociationMappingPreferencePage
{
	private IAssociationMappingRegistry registry;
	
	/**
	 * Constructor for TestSuiteAssocitation
	 */
	public TestSuiteAssociation()
	{
		super();	
		registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage#beforeIsPresented()
	 */
	protected void beforeIsPresented()
	{
		registry.checkpoint();
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose()
	{
		registry.clearCheckpoint();
		registry = null;
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionAssociationMapping()
	 */
	protected IAssociationMapping getSelectionAssociationMapping()
	{
		return registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationRegistryPreferencePage#getDetailMappings()
	 */
	public IAssociationMapping[] getDetailMappings()
	{
		// Run Wizards are deprecated and replaced by Run Configuration.
		//IAssociationMapping[] associationMappings = new IAssociationMapping[3];
		IAssociationMapping[] associationMappings = new IAssociationMapping[2];
		associationMappings[0] = registry.getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		associationMappings[1] = registry.getAssociationMapping(UiPlugin.EP_GENERATE_WIZARDS);
		//associationMappings[2] = registry.getAssociationMapping(UiPlugin.EP_RUN_WIZARDS);		
		return associationMappings;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionLabel()
	 */
	public String getSelectionLabel()
	{
		return UiPluginResourceBundle.testSuiteSelectionLabel; 
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getLabel(IAssociationMapping)
	 */
	protected String getLabel(IAssociationMapping associationMapping)
	{
		if(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS.equals(associationMapping.getExtensionPoint()))
			return UiPluginResourceBundle.LBL_TST_SUITE_TYPE_DSC; 

		if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(associationMapping.getExtensionPoint()))
			return UiPluginResourceBundle.TAB_EDT_EXTS; 

		if(UiPlugin.EP_GENERATE_WIZARDS.equals(associationMapping.getExtensionPoint()))
			return UiPluginResourceBundle.TAB_GEN_WIZ; 

		return null;
	}
	
	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performCancel()
	 */
	public boolean performCancel()
	{
		return registry.rollback();
	}

	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk()
	{
		if(!registry.commit())
			return false;
			
		UiPlugin.getInstance().savePluginPreferences();
		return true;
	}
	
	protected Control createContents(Composite parent)
	{
		Control control = super.createContents(parent);
		
		UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(parent, UiPlugin.getID() + ContextIds.ASSOC_PREF_CONT);												
		
		Dialog.applyDialogFont( control );
		
		return control;
	}	
	
}
