/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InvocationEventSearchProvider.java,v 1.7 2007/05/03 17:32:15 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Search provider class for Invocation Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class InvocationEventSearchProvider extends ExecutionEventSearchProvider implements SelectionListener
{
	private boolean searchSuccessful;
	private Button successful;
	private boolean searchUnsuccessful;
	private Button unsuccessful;
	private boolean searchUnattempted;
	private Button unattempted;
	
	public void createContents(Composite parent) {
		super.createContents(parent);
		
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		group.setText(UiPluginResourceBundle.TestLogSearch_LimitToInvocationStatus); 
		group.setLayoutData(new GridData());
		group.setLayout(new GridLayout(2, true));
		
		successful = new Button(group, SWT.CHECK);
		successful.setText(TPFInvocationStatus.SUCCESSFUL_LITERAL.getLabel()); //$NON-NLS-1$
		successful.addSelectionListener(this);
		unsuccessful = new Button(group, SWT.CHECK);
		unsuccessful.setText(TPFInvocationStatus.UNSUCCESSFUL_LITERAL.getLabel()); //$NON-NLS-1$
		unsuccessful.addSelectionListener(this);
		unattempted = new Button(group, SWT.CHECK);
		unattempted.setText(TPFInvocationStatus.UNATTEMPTED_LITERAL.getLabel()); //$NON-NLS-1$
		unattempted.addSelectionListener(this);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) {
		SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		if(searchSuccessful)
		{
			BinaryExpression successfulSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), 
										TPFInvocationStatus.SUCCESSFUL_LITERAL.toString());
			or.getArguments().add(successfulSearch);
		}
		if(searchUnsuccessful)
		{
			BinaryExpression unsuccessfulSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), 
										TPFInvocationStatus.UNSUCCESSFUL_LITERAL.toString());
			or.getArguments().add(unsuccessfulSearch);
		}
		if(searchUnattempted)
		{
			BinaryExpression unattemptedSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFInvocationEvent_Status(), 
						TPFInvocationStatus.UNATTEMPTED_LITERAL.toString());
			or.getArguments().add(unattemptedSearch);
		}
		
		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		
		if(e.widget == successful)
			searchSuccessful = successful.getSelection();
		else if(e.widget == unsuccessful)
			searchUnsuccessful = unsuccessful.getSelection();
		else if(e.widget == unattempted)
			searchUnattempted = unattempted.getSelection();

		super.widgetSelected(e);
	}
}
