/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LogResultTableContentProvider.java,v 1.1 2006/03/15 20:25:09 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogResultTableContentProvider implements IStructuredContentProvider, ILogResultContentProvider {

	private TestLogSearchResult result;
	private TestLogSearchResultPage resultPage;
	
	public LogResultTableContentProvider(TestLogSearchResultPage page)
	{
		this.resultPage = page;
	}
	
	public Object[] getElements(Object inputElement) {
		if(inputElement instanceof TestLogSearchResult)
		{
			result = (TestLogSearchResult)inputElement;
			return result.getElements();
		}
		return new Object[0];
	}

	public void dispose() {
		result = null;
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if(newInput instanceof TestLogSearchResult)
			result = (TestLogSearchResult)newInput;
	}
	
	public void elementsChanged(Object[] updatedElements) {
		TableViewer viewer= (TableViewer)resultPage.getViewer();
		for (int i= 0; i < updatedElements.length; i++) {
			if (result.getMatchCount(updatedElements[i]) > 0) {
				if (viewer.testFindItem(updatedElements[i]) != null)
					viewer.update(updatedElements[i], null);
			} else
				viewer.remove(updatedElements[i]);
		}
	}
	
	public void clear() {
		resultPage.getViewer().refresh();
	}
}
