/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoopEventSearchProvider.java,v 1.7 2007/05/03 17:32:43 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;

/**
 * Search provider class for Loop Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class LoopEventSearchProvider extends ExecutionEventSearchProvider 
{
	private boolean searchAsynchronous;
	private Boolean asynchronous = Boolean.FALSE;
	private Button asyncButton;
	private Combo asyncCombo;
	private boolean searchIterations;
	private Integer iterations = new Integer(0);
	private Button iterButton;
	private Spinner iterSpinner;
	
	public void createContents(Composite parent) {
		super.createContents(parent);
		
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		group.setText(UiPluginResourceBundle.TestLogSearch_LimitToLoops); 
		group.setLayoutData(new GridData());
		group.setLayout(new GridLayout(2, false));
		
		asyncButton = new Button(group, SWT.CHECK);
		asyncButton.setText(UiPluginResourceBundle.TestLogSearch_Asynchronous);
		asyncButton.addSelectionListener(this);
		asyncCombo = new Combo(group, SWT.BORDER | SWT.READ_ONLY);
		asyncCombo.setItems(new String[]{UiPluginResourceBundle.Word_False, UiPluginResourceBundle.Word_True});
		asyncCombo.setText(UiPluginResourceBundle.Word_False);
		asyncCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		asyncCombo.addSelectionListener(this);
		asyncCombo.setEnabled(false);
		
		iterButton = new Button(group, SWT.CHECK);
		iterButton.setText(UiPluginResourceBundle.TestLogSearch_Iterations);
		iterButton.addSelectionListener(this);
		iterSpinner = new Spinner(group, SWT.BORDER);
		iterSpinner.setMinimum(0);
		iterSpinner.setMaximum(Integer.MAX_VALUE);
		iterSpinner.addSelectionListener(this);
		iterSpinner.setEnabled(false);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) 
	{
		SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		if(searchAsynchronous)
		{
			BinaryExpression asynchronousSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent_Asynchronous(), 
										EcorePackage.eINSTANCE.getEBoolean(),
										asynchronous);
			or.getArguments().add(asynchronousSearch);
		}
		if(searchIterations)
		{
			BinaryExpression iterationsSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFLoopEvent_Iterations(), 
										EcorePackage.eINSTANCE.getEIntegerObject(),
										iterations);
			or.getArguments().add(iterationsSearch);
		}
		
		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	public void widgetSelected(SelectionEvent e) {
		
		if(e.widget == asyncButton)
		{
			searchAsynchronous = asyncButton.getSelection();
			asyncCombo.setEnabled(asyncButton.getSelection());
		}
		else if(e.widget == asyncCombo)
		{
			if(UiPluginResourceBundle.Word_False.equals(asyncCombo.getText()))
				asynchronous = Boolean.FALSE;
			else
				asynchronous = Boolean.TRUE;
		}
		else if(e.widget == iterButton)
		{
			searchIterations = iterButton.getSelection();
			iterSpinner.setEnabled(iterButton.getSelection());
		}
		else if(e.widget == iterSpinner)
			iterations = new Integer(iterSpinner.getSelection());
		
		super.widgetSelected(e);
	}
}
