/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MessageEventSearchProvider.java,v 1.7 2007/05/03 17:33:11 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.ExecutionEventSearchProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/**
 * Search provider class for Message Event element in Test Log Search.
 * 
 * @see extension point "org.eclipse.hyades.test.ui.testLogSearchProvider"
 * @see org.eclipse.hyades.test.ui.forms.extensions.provisional.ITestLogSearchProvider
 * @author bjiang
 * @since 4.2
 */
public class MessageEventSearchProvider extends ExecutionEventSearchProvider implements SelectionListener 
{
	private boolean searchInfo;
	private Button info;
	private boolean searchError;
	private Button error;
	private boolean searchWarning;
	private Button warning;
	
	public void createContents(Composite parent) 
	{
		super.createContents(parent);
		
		Group group = new Group(parent, SWT.SHADOW_ETCHED_IN);
		group.setText(UiPluginResourceBundle.TestLogSearch_LimitToMessageSeverity); 
		group.setLayoutData(new GridData());
		group.setLayout(new GridLayout(3, true));
		
		info = new Button(group, SWT.CHECK);
		info.setText(TPFSeverity.INFO_LITERAL.getLabel()); //$NON-NLS-1$
		info.addSelectionListener(this);
		error = new Button(group, SWT.CHECK);
		error.setText(TPFSeverity.ERROR_LITERAL.getLabel()); //$NON-NLS-1$
		error.addSelectionListener(this);
		warning = new Button(group, SWT.CHECK);
		warning.setText(TPFSeverity.WARNING_LITERAL.getLabel()); //$NON-NLS-1$
		warning.addSelectionListener(this);
	}
	
	public SimpleSearchQuery createSearchQuery(EObject rootElement, String text, Map options) 
	{
		SimpleSearchQuery query = super.createSearchQuery(rootElement, text, options);		
		
		setQueryOutputType(query, Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent());
		LogicalExpression executionEventOR = (LogicalExpression)query.getWhereExpression();
		LogicalExpression or = createORExpression();
		
		if(searchInfo)
		{
			BinaryExpression infoSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), 
										TPFSeverity.INFO_LITERAL.toString());
			or.getArguments().add(infoSearch);
		}
		if(searchError)
		{
			BinaryExpression errorSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), 
										TPFSeverity.ERROR_LITERAL.toString());
			or.getArguments().add(errorSearch);
		}
		if(searchWarning)
		{
			BinaryExpression warningSearch = 
				createBinaryExpression(Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent_Severity(), 
										TPFSeverity.WARNING_LITERAL.toString());
			or.getArguments().add(warningSearch);
		}
		
		combineExecutionEventAndElementExpressions(query, executionEventOR, or);
		
		return query;
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		if(e.widget == info)
			searchInfo = info.getSelection();
		else if(e.widget == error)
			searchError = error.getSelection();
		else if(e.widget == warning)
			searchWarning = warning.getSelection();

		super.widgetSelected(e);
	}
}
