/*******************************************************************************
 * Copyright (c) 2006, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestLogSearchQuery.java,v 1.8 2009/08/12 13:44:04 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.internal.SinglePassSimpleSearchQueryEngine;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.IEditorInput;

/**
 * <p>TestLogSearchQuery.java</p>
 * 
 * 
 * @author  Bianca Xue Jiang 
 * @author  Paul E. Slauenwhite
 * @version August 11, 2009
 * @since   March 15, 2006
 */
public class TestLogSearchQuery implements ISearchQuery {

	private TestLogSearchResult result = null;
	private SimpleSearchQuery[] queries = null;
	private String testLogName = null;
	private IEditorInput editorInput = null;
	private String searchQueryText = null;
	private ResourceSet resourceSet = null;
	
	public TestLogSearchQuery(SimpleSearchQuery[] queries, ResourceSet resourceSet, IEditorInput input, String testLogName, String searchQueryText)
	{
		this.queries = queries;
		this.resourceSet = resourceSet;
		this.editorInput = input;
		this.testLogName = testLogName;
		this.searchQueryText = searchQueryText;
	}
		
	public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
		TestLogSearchResult result = (TestLogSearchResult)getSearchResult();
		result.removeAll();
		
		try {
			SinglePassSimpleSearchQueryEngine engine = null;
			QueryResult queryResult = null;
			List resultEntries = null;
			List resultValues = null;
			for(int i = 0; i < queries.length; i++)
			{
				// TODO add progress bar?
				//try {				

				if(ModelDebugger.INSTANCE.debugDatabaseResourcePostfix!=null)
				{
					IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(URI.createURI((String)queries[i].getSources().get(0)).trimFragment()));
					if (hyadesResourceExtension != null) {
						List notLoadedTypes = new ArrayList();
						queryResult = hyadesResourceExtension.executeQuery(queries[i], resourceSet, notLoadedTypes);
					}
					else
					{
						engine = new SinglePassSimpleSearchQueryEngine(queries[i], resourceSet);
						queryResult = engine.execute();
					}
				}
				else
				{
					engine = new SinglePassSimpleSearchQueryEngine(queries[i], resourceSet);
					queryResult = engine.execute();
				}
				
				resultEntries = queryResult.getResultEntries();
				if(resultEntries.size() > 0)
				{
					resultValues = (List)((ResultEntry)resultEntries.get(0)).getValue();
					if(resultValues.size() > 0)
					{
						for(Iterator it = resultValues.iterator(); it.hasNext();)
						result.addMatch(new TestLogElementMatch((EObject)it.next()));
					}
				}
				//} catch (Exception e) {
				//	UiPlugin.logError(e);
				//}
			}			
			
			/*if(searchElement instanceof TPFExecutionResult)
			{
				
				List lists = ((TPFExecutionResult)searchElement).getVerdictLists();
				TPFVerdictList list = null;
				List verdictEvents = null;
				for(Iterator it = lists.iterator(); it.hasNext();)
				{
					list = (TPFVerdictList)it.next();
					if(list.getType().equals(TPFVerdictList.VERDICT_TYPE_ALL))
					{
						verdictEvents = list.getVerdictEvents();
						break;
					}
	
					if(list.getType().equals(TPFVerdict.ERROR_LITERAL.getName()) |
						list.getType().equals(TPFVerdict.FAIL_LITERAL.getName()))
					{
						List verdicts = list.getVerdictEvents();
						for(Iterator verIt = verdicts.iterator(); verIt.hasNext();)
						{
							result.addMatch(new TestLogElementMatch((TPFVerdictEvent)verIt.next()));
						}
					}
				}
				if(list != null)
				{
					TestLogSearchEngine searchEngine = TestLogSearchEngine.createDefault();
					QueryResult qResult = searchEngine.search((TPFExecutionResult)searchElement, null, resourceSet);
					List resultEntries = qResult.getResultEntries();
					for(Iterator it = resultEntries.iterator(); it.hasNext();)
					{
						ResultEntry entry = (ResultEntry)it.next();
						Object value = entry.getValue();
						if(value instanceof List)
						{
							for(Iterator i = ((List)value).iterator(); i.hasNext();)
								result.addMatch(new TestLogElementMatch((EObject)i.next()));
						}
						else if(entry instanceof EObject)
							result.addMatch(new TestLogElementMatch((EObject)value));
						
					}
				}
			}*/
		}
		catch (Exception e) {
			return new Status(IStatus.ERROR, UiPlugin.getID(), IStatus.ERROR, "", e);
		}
		
		return new Status(IStatus.OK, UiPlugin.getID(), IStatus.OK, "", null);
	}

	public String getLabel() {
		// TODO Auto-generated method stub
		return UiPluginResourceBundle.TestLogSearch_QueryLabel; 
	}

	public String getSearchQueryText(){
		return searchQueryText;
	}

	public String getTestLogName(){
		return testLogName;
	}

	public boolean canRerun() {
		return true;
	}

	public boolean canRunInBackground() {
		return true;
	}

	public ISearchResult getSearchResult() {
		if(result == null)
			result = new TestLogSearchResult(this);
		
		return result;
	}

	public IEditorInput getEditorInput()
	{
		return editorInput;
	}
}
